--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- An NPC object that has been cloned. Typically represents an NPC that has been instanced in the world.
--- @class tes3npcInstance : tes3actor, tes3physicalObject, tes3object, tes3baseObject
--- @field aiConfig tes3aiConfig *Read-only*. A substructure off of actors that contains information on the current AI configuration.
--- @field attributes number[] Quick access to the base NPC's attributes.
--- 
--- !!! note
--- 	This array is 1-indexed. The array indices correspond to the [`tes3.attribute`](https://mwse.github.io/MWSE/references/attributes/) table plus 1 to account for Lua's 1-based array indexing. In other words `npc.attributes[tes3.attribute.speed + 1]` returns the attribute value corresponding to Speed.
--- @field autoCalc boolean Direct access to the actor autocalc flag.
--- @field baseDisposition number The actor's base disposition as read from the esm/esp file(s), before any modifiers are applied.
--- @field baseObject tes3npc *Read-only*. Access to the base NPC object.
--- @field class tes3class *Read-only*. Quick access to the base NPC's class.
--- @field disposition number *Read-only*. The actor's effective disposition, with all [modifiers applied](https://wiki.openmw.org/index.php?title=Research:Disposition_and_Persuasion#Disposition).
--- @field faction tes3faction *Read-only*. Quick access to the base NPC's faction.
--- @field factionRank number *Read-only*. Quick access to the base NPC's faction rank.
--- @field fatigue number *Read-only*. Quick access to the base NPC's fatigue.
--- @field female boolean Direct access to the actor female flag.
--- @field health number *Read-only*. Quick access to the base NPC's health.
--- @field height number *Read-only*. Convenience access to the NPCs (race) height.
--- @field isAttacked boolean *Read-only*. If true, the actor's attacked flag is set.
--- @field isEssential boolean *Read-only*. If true, the actor's essential flag is set.
--- @field isGuard boolean *Read-only*. If true, the actor is a guard.
--- @field isInstance boolean Always returns true.
--- @field isRespawn boolean *Read-only*. If true, the actor's respawn flag is set.
--- @field level number *Read-only*. Quick access to the base NPC's level.
--- @field magicka number *Read-only*. Quick access to the base NPC's magicka.
--- @field mesh string The path to the object's mesh.
--- @field mobile tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer *Read-only*. The mobile that the object is represented by.
--- @field name string Quick access to the base NPC's name.
--- @field race tes3race *Read-only*. Quick access to the base NPC's race.
--- @field reference tes3reference *Read-only*. The reference that the object is represented by.
--- @field reputation number The actor's reputation.
--- @field script tes3script *Read-only*. Quick access to the base NPC's script.
--- @field skills number[] Quick access to the base NPC's skills.
--- 
--- !!! note
--- 	This array is 1-indexed. The array indices correspond to the [`tes3.skill`](https://mwse.github.io/MWSE/references/skills/) table plus 1 to account for Lua's 1-based array indexing. In other words `npc.skills[tes3.skill.armorer + 1]` returns the skill value corresponding to the Armorer skill.
--- @field soul number|nil The soul value for this NPC's base object. This is typically `nil`, unless the `calcSouLValue` event provides one for the base actor.
--- @field spells tes3spellList|tes3spell[] *Read-only*. Quick access to the NPC's spell list. It is a `tes3spellList`, which is a list wrapper with helper functions. The actual list is iterated over using `pairs`. E.g. `for _, spell in pairs(npc.spells) do print(spell.name) end`
--- @field weight number *Read-only*. Convenience access to the NPCs (race) weight.
tes3npcInstance = {}

--- Causes the NPC to reevaluate his/hers equipment choices and equip the best available. Then, the visible body parts will be updated.
function tes3npcInstance:reevaluateEquipment() end

